/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.compat.playerAnim;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.nyatla.nymmd.MmdException;
import jp.nyatla.nymmd.MmdMotionPlayerGL2;
import jp.nyatla.nymmd.MmdPmdModelMc;
import jp.nyatla.nymmd.MmdPmdModel_BasicClass;
import jp.nyatla.nymmd.MmdVmdMotionMc;
import jp.nyatla.nymmd.core.PmdBone;
import jp.nyatla.nymmd.types.MmdVector3;
import mods.flammpfeil.slashblade.client.renderer.model.BladeMotionManager;
import mods.flammpfeil.slashblade.util.TimeValueHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VmdAnimation
implements IAnimation {
    static final LazyOptional<MmdPmdModelMc> alex = LazyOptional.of(() -> {
        try {
            return new MmdPmdModelMc(new ResourceLocation("slashblade", "model/pa/alex.pmd"));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (MmdException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    });
    static final LazyOptional<MmdMotionPlayerGL2> motionPlayer = LazyOptional.of(() -> {
        MmdMotionPlayerGL2 mmp = new MmdMotionPlayerGL2();
        alex.ifPresent(pmd -> {
            try {
                mmp.setPmd((MmdPmdModel_BasicClass)pmd);
            }
            catch (MmdException e) {
                e.printStackTrace();
            }
        });
        return mmp;
    });
    int currentTick;
    final ResourceLocation loc;
    double start;
    double end;
    double span;
    boolean loop;
    private boolean isRunning = true;
    private boolean blendArms = false;
    private boolean blendLegs = true;
    static final Map<String, String> nameMap = VmdAnimation.initNamemap();
    static final List<String> arms = Lists.newArrayList((Object[])new String[]{"leftArm", "rightArm"});
    static final List<String> legs = Lists.newArrayList((Object[])new String[]{"leftLeg", "rightLeg"});

    private static Map<String, String> initNamemap() {
        HashMap map = Maps.newHashMap();
        map.put("leftArm", "left arm");
        map.put("rightArm", "right arm");
        map.put("leftLeg", "left leg");
        map.put("rightLeg", "right leg");
        return map;
    }

    public VmdAnimation(ResourceLocation loc, double start, double end, boolean loop) {
        this.loc = loc;
        this.start = start;
        this.end = end;
        this.span = TimeValueHelper.getTicksFromFrames((float)Math.abs(end - start));
        this.loop = loop;
        this.currentTick = 0;
    }

    public VmdAnimation getClone() {
        VmdAnimation tmp = new VmdAnimation(this.loc, this.start, this.end, this.loop);
        tmp.setBlendArms(this.blendArms);
        tmp.setBlendLegs(this.blendLegs);
        return tmp;
    }

    public VmdAnimation setBlendArms(boolean blend) {
        this.blendArms = blend;
        return this;
    }

    public VmdAnimation setBlendLegs(boolean blend) {
        this.blendLegs = blend;
        return this;
    }

    public void tick() {
        if (this.isRunning) {
            ++this.currentTick;
            double endTicks = this.span;
            this.loop = false;
            if (this.loop && endTicks < (double)this.currentTick) {
                this.currentTick = 0;
            }
            if (endTicks <= (double)this.currentTick) {
                this.stop();
            }
        }
    }

    public void play() {
        this.currentTick = 0;
        this.isRunning = true;
    }

    public void stop() {
        this.isRunning = false;
    }

    public boolean isActive() {
        return this.isRunning;
    }

    @NotNull
    public Vec3f get3DTransform(@NotNull String modelName, @NotNull TransformType type, float tickDelta, @NotNull Vec3f value0) {
        PmdBone bone;
        this.setupAnim(tickDelta);
        double motionScale = 0.0625;
        float bodyScale = (float)motionScale;
        float finalizeScale = 2.0f;
        Vector3f blend = new Vector3f(((Float)value0.getX()).floatValue(), ((Float)value0.getY()).floatValue(), ((Float)value0.getZ()).floatValue());
        if (type != TransformType.POSITION && (!this.blendArms && arms.contains(modelName) || !this.blendLegs && legs.contains(modelName))) {
            blend.mul(0.0f);
        }
        if (!motionPlayer.isPresent()) {
            return value0;
        }
        MmdMotionPlayerGL2 mmp = (MmdMotionPlayerGL2)motionPlayer.orElse(null);
        String boneName = modelName;
        if (nameMap.containsKey(modelName)) {
            boneName = nameMap.get(modelName);
        }
        if ((bone = mmp.getBoneByName(boneName)) != null) {
            switch (type) {
                case POSITION: {
                    MmdVector3 org = bone.m_vec3Position;
                    Vector3f tmp = new Vector3f(org.x, org.y, org.z);
                    tmp = modelName.equals("body") ? tmp.mul(bodyScale) : tmp.mul(1.0f, -1.0f, 1.0f);
                    tmp.mul(finalizeScale).add((Vector3fc)blend);
                    return new Vec3f(tmp.x, tmp.y, tmp.z);
                }
                case ROTATION: {
                    Quaterniond qt = new Quaterniond(bone.m_vec4Rotate.x, bone.m_vec4Rotate.y, bone.m_vec4Rotate.z, bone.m_vec4Rotate.w);
                    Vector3d tmp = this.QuaternionToEulerZYX(qt);
                    tmp = modelName.equals("body") ? tmp.mul(1.0, -1.0, -1.0) : tmp.mul(-1.0, 1.0, -1.0);
                    tmp.add((Vector3fc)blend);
                    return new Vec3f((float)tmp.x, (float)tmp.y, (float)tmp.z);
                }
            }
        }
        return value0;
    }

    Vector3d QuaternionToEulerZYX(Quaterniond qt) {
        Vector3d tmp = new Vector3d();
        double a_x_x = Math.pow(qt.w, 2.0) + Math.pow(qt.x, 2.0) - Math.pow(qt.y, 2.0) - Math.pow(qt.z, 2.0);
        double a_x_y = 2.0 * (qt.x * qt.y + qt.w * qt.z);
        double a_x_z = 2.0 * (qt.x * qt.z - qt.w * qt.y);
        double a_y_z = 2.0 * (qt.y * qt.z + qt.w * qt.x);
        double a_z_z = Math.pow(qt.w, 2.0) - Math.pow(qt.x, 2.0) - Math.pow(qt.y, 2.0) + Math.pow(qt.z, 2.0);
        tmp.z = Math.atan2(a_x_y, a_x_x);
        tmp.y = Math.asin(-a_x_z);
        tmp.x = Math.atan2(a_y_z, a_z_z);
        return tmp;
    }

    public void setupAnim(float tickDelta) {
        if (!motionPlayer.isPresent()) {
            return;
        }
        MmdMotionPlayerGL2 mmp = (MmdMotionPlayerGL2)motionPlayer.orElse(null);
        double eofTime = 0.0;
        MmdVmdMotionMc motion = BladeMotionManager.getInstance().getMotion(this.loc);
        try {
            mmp.setVmd(motion);
            eofTime = TimeValueHelper.getMSecFromFrames(motion.getMaxFrame());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double time = TimeValueHelper.getMSecFromTicks((float)((double)this.currentTick + (double)tickDelta));
        time = Math.min(eofTime, time);
        time = TimeValueHelper.getMSecFromFrames((float)this.start) + time;
        try {
            mmp.updateMotion((float)time);
        }
        catch (MmdException e) {
            e.printStackTrace();
        }
    }
}

